package com.scnyw.trip.tcc.enums;

import com.scnyw.trip.order.enums.OrderPayStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * tcc业务类型
 *
 * @author JSON
 */
@Getter
@AllArgsConstructor
public enum TccBusinessTypeEnum {
    /**
     * 库存
     */
    STOCK("STOCK", "库存"),
    ORDER("ORDER", "订单"),
    ORDER_PAY("ORDER_PAY", "支付订单");

    private String code;

    private String desc;

    public static OrderPayStatusEnum getTypeByCode(String code) {
        for (OrderPayStatusEnum c : OrderPayStatusEnum.values()) {
            if (c.getCode().equals(code)) {
                return c;
            }
        }
        return null;
    }
}
