/*
 * Copyright 2020-2030, MateCloud, DAOTIANDI Technology Inc All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Author: pangu(7333791@qq.com)
 */
package com.scnyw.trip.tcc.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.scnyw.common.db.LongBaseEntity;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * TCC 幂等控制表，用于记录 TCC 的 Try、Confirm 和 Cancel 操作与幂等控制，并作为防悬挂与空回滚的依据实体类
 *
 * @author zhuangjiali
 * @since 2025-01-10
 */
@Data
@TableName("tx_tcc_idempotent")
@Schema(name = "TccIdempotentEntity对象", description = "TCC 幂等控制表，用于记录 TCC 的 Try、Confirm 和 Cancel 操作与幂等控制，并作为防悬挂与空回滚的依据")
public class TccIdempotentEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 主键id
	 */
	@JsonSerialize(using = ToStringSerializer.class)
	@Schema(description = "主键id")
	@TableId(value = "id", type = IdType.AUTO)
	private Long id;
	/**
	* Seata 全局事务 ID
	*/
	@Schema(description = "Seata 全局事务 ID")
	private String xid;
	/**
	* 操作阶段（TRY、CONFIRM、CANCEL）
	*/
	@Schema(description = "操作阶段（TRY、CONFIRM、CANCEL）")
	private String action;
	/**
	* 重试次数
	*/
	@Schema(description = "重试次数")
	private Integer retryCount;
	/**
	* 记录创建时间
	*/
	@Schema(description = "记录创建时间")
	private LocalDateTime createdAt;
	/**
	* 最后更新时间
	*/
	@Schema(description = "最后更新时间")
	private LocalDateTime updatedAt;
	/**
	* 错误信息，用于记录失败原因
	*/
	@Schema(description = "错误信息，用于记录失败原因")
	private String errorMessage;


}
